/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.network;

import com.ibm.hwmca.base.settings.SettingsConstants;
import com.ibm.hwmca.base.settings.network.NetAppFirewallRule;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.ValueDescriptor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;

public class FirewallAddressBean
extends PanelBean
implements SettingsConstants {
    private String macAddr;
    private String appId;
    private String appName;
    private String ipAddr;
    private String netMask;
    private String hostsAllowed;
    private ArrayList hostsAllowedList;
    private boolean dataChangedFlag;
    private String ifName;
    private String destAddr;
    private String protocol;
    private String port;
    private static final String TRACE_MASKT = "XSETFWBT";
    private static final String TRACE_MASKF = "XSETFWBF";
    private static final String TRACE_MASKD = "XSETFWBD";

    public String getMacAddr() {
        return this.macAddr;
    }

    public void setMacAddr(String s) throws IllegalUserDataException {
        this.macAddr = s;
    }

    public String getApplicationNameOutput() {
        return this.appName;
    }

    public void setApplicationNameOutput(String s) throws IllegalUserDataException {
        this.appId = s;
    }

    public String getIPAddress() {
        return this.ipAddr;
    }

    public void setIPAddress(String s) throws IllegalUserDataException {
        this.ipAddr = s;
    }

    public String getNetworkMask() {
        return this.netMask;
    }

    public void setNetworkMask(String s) throws IllegalUserDataException {
        this.netMask = s;
    }

    public String getHostsAllowed() {
        return this.hostsAllowed;
    }

    public void setHostsAllowed(String s) throws IllegalUserDataException {
        this.hostsAllowed = s;
    }

    public ValueDescriptor[] getHostsAllowedList() {
        ValueDescriptor[] vd = new ValueDescriptor[this.hostsAllowedList.size()];
        for (int i = 0; i < this.hostsAllowedList.size(); ++i) {
            String hosts = (String)this.hostsAllowedList.get(i);
            vd[i] = new ValueDescriptor(hosts, hosts);
        }
        return vd;
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void verifyChanges() throws IllegalUserDataException {
    }

    public void save() {
    }

    public boolean getDataChanged() {
        return this.dataChangedFlag;
    }

    public void setDataChanged() {
        this.dataChangedFlag = true;
    }

    public void load() {
        this.hostsAllowedList = new ArrayList();
    }

    public void setParms(String[] parms) {
        this.appId = parms[0];
        this.appName = parms[1];
        this.ifName = parms[2];
        this.destAddr = parms[3];
        this.protocol = parms[4];
        this.port = parms[5];
        this.macAddr = parms[6];
    }

    public void panelAction(TaskActionEvent event) {
        block15: {
            Trace.trace(TRACE_MASKT, "-> FirewallAddressBean.panelAction: event=" + event);
            String command = event.getElementName();
            if (command.endsWith("addHost")) {
                Trace.trace(TRACE_MASKF, "FirewallAddressBean: they hit 'addHost'");
                this.userTaskManager.storeElement(this.getMountPrefix() + "IPAddress");
                this.userTaskManager.storeElement(this.getMountPrefix() + "NetworkMask");
                try {
                    InetAddress.getByName(this.ipAddr);
                    InetAddress.getByName(this.netMask);
                    String entry = this.ipAddr + "/" + this.netMask;
                    if (this.hostsAllowedList.contains(entry)) {
                        try {
                            CommonMsgApp.showMessageBox(this.userTaskManager, new LocalizableText("Error - XXX"), new BaseMessageText("SETFW002E"), MsgType.ERROR_MESSAGE);
                        }
                        catch (HException hexc) {
                            Trace.trace(TRACE_MASKF, hexc);
                        }
                        break block15;
                    }
                    this.hostsAllowedList.add(this.ipAddr + "/" + this.netMask);
                    this.userTaskManager.refreshElement(this.getMountPrefix() + "HostsAllowed");
                }
                catch (UnknownHostException e) {
                    try {
                        CommonMsgApp.showMessageBox(this.userTaskManager, new LocalizableText("Error - XXX"), new BaseMessageText("SETFW001E"), MsgType.ERROR_MESSAGE);
                    }
                    catch (HException hexc) {
                        Trace.trace(TRACE_MASKF, hexc);
                    }
                }
            } else if (command.endsWith("removeHost")) {
                Trace.trace(TRACE_MASKF, "FirewallAddressBean: they hit 'removeHost'");
                Trace.trace(TRACE_MASKF, "FirewallAddressBean: hostsAllowed=" + this.hostsAllowed);
                this.hostsAllowedList.remove(this.hostsAllowed);
                this.userTaskManager.refreshElement(this.getMountPrefix() + "HostsAllowed");
            } else if (command.endsWith("firewallOkButton")) {
                Trace.trace(TRACE_MASKF, "FirewallAddressBean: they hit ok");
                Trace.trace(TRACE_MASKF, "ipAddr=" + this.ipAddr + " netMask=" + this.netMask);
                ArrayList<NetAppFirewallRule> rules = new ArrayList<NetAppFirewallRule>();
                Iterator it = this.hostsAllowedList.iterator();
                while (it.hasNext()) {
                    String s = (String)it.next();
                    int i = s.indexOf("/");
                    String host = s.substring(0, i);
                    String mask = s.substring(i + 1);
                    NetAppFirewallRule rule = new NetAppFirewallRule(this.appId, this.ifName, host, mask, this.protocol, this.port);
                    rules.add(rule);
                }
                PanelTaskletRequest request = new PanelTaskletRequest("FirewallAddressPanel");
                request.setData("panel", "FirewallAddressPanel");
                request.setData("action", "okButton");
                request.setData("data", rules);
                this.postTaskletRequest(request);
            } else if (command.endsWith("firewallCancelButton")) {
                Trace.trace(TRACE_MASKF, "FirewallAddressBean: they hit cancel");
                PanelTaskletRequest request = new PanelTaskletRequest("FirewallAddressPanel");
                request.setData("panel", "FirewallAddressPanel");
                request.setData("action", "cancelButton");
                this.postTaskletRequest(request);
            }
        }
        Trace.trace(TRACE_MASKT, "<- FirewallAddressBean.panelAction");
    }
}

